/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic;

import com.google.common.base.Strings;
import net.dries007.tfc.Constants;

public class WorldGenSettings {
    public final int spawnFuzz;
    public final boolean flatBedrock;
    public final int rockLayerSize;
    public final int ravineRarity;
    public final int ravineHeight;
    public final int ravineVariability;
    public final int surfaceRavineRarity;
    public final int surfaceRavineHeight;
    public final int surfaceRavineVariability;
    public final int riverRavineRarity;
    public final int lavaFissureRarity = 25;
    public final int waterFissureRarity = 90;
    public final int lavaFissureClusterRarity = 400;
    public final int waterFissureClusterRarity = 225;
    public final int largeRockRarity = 20;

    public static WorldGenSettingsBuilder fromString(String options) {
        if (Strings.isNullOrEmpty((String)options)) {
            return new WorldGenSettingsBuilder();
        }
        return (WorldGenSettingsBuilder)Constants.GSON.fromJson(options, WorldGenSettingsBuilder.class);
    }

    public WorldGenSettings(WorldGenSettingsBuilder b) {
        this.spawnFuzz = b.spawnFuzz;
        this.flatBedrock = b.flatBedrock;
        this.rockLayerSize = b.rockLayerSize;
        this.ravineRarity = b.ravineRarity;
        this.ravineHeight = b.ravineHeight;
        this.ravineVariability = b.ravineVariability;
        this.surfaceRavineRarity = b.surfaceRavineRarity;
        this.surfaceRavineHeight = b.surfaceRavineHeight;
        this.surfaceRavineVariability = b.surfaceRavineVariability;
        this.riverRavineRarity = b.riverRavineRarity;
    }

    public String toString() {
        return Constants.GSON.toJson((Object)this);
    }

    public static class WorldGenSettingsBuilder {
        public int spawnFuzz = 250;
        public boolean flatBedrock = false;
        public int rockLayerSize = 5;
        public int ravineRarity = 100;
        public int ravineHeight = 20;
        public int ravineVariability = 50;
        public int surfaceRavineRarity = 100;
        public int surfaceRavineHeight = 125;
        public int surfaceRavineVariability = 30;
        public int riverRavineRarity = 400;

        public boolean isDefault() {
            return this.spawnFuzz == 250 && !this.flatBedrock && this.rockLayerSize == 5 && this.ravineRarity == 100 && this.ravineHeight == 20 && this.ravineVariability == 50 && this.surfaceRavineRarity == 100 && this.surfaceRavineHeight == 125 && this.surfaceRavineVariability == 30 && this.riverRavineRarity == 400;
        }

        public WorldGenSettings build() {
            return new WorldGenSettings(this);
        }

        public String toString() {
            return Constants.GSON.toJson((Object)this);
        }
    }
}

